/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>

#define COOKBOOK_PURPLE_COLOR [UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) [[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]

@interface TestBedViewController : UITableViewController <UIScrollViewDelegate>
{
    int numberOfItems;
	BOOL addItemsTrigger;
}
@end

@implementation TestBedViewController

- (NSInteger)numberOfSectionsInTableView:(UITableView *)aTableView 
{ 
	return 1; 
}

- (NSInteger)tableView:(UITableView *)aTableView numberOfRowsInSection:(NSInteger)section 
{
    return numberOfItems;
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
	// Wykrycie, czy procedura wyzwalająca została zdefiniowana. Jeśli tak, należy dodać nowe elementy i odświeżyć tabelę.
	if (addItemsTrigger)
	{
		numberOfItems += 2;
		[self.tableView reloadData];
	}
    
	// Wyzerowanie procedury wyzwalającej.
	addItemsTrigger = NO;
}

- (void) scrollViewDidScroll:(UIScrollView *)scrollView
{
	// Wyzwolenie procedury, jeśli użytkownik przeciągnął tabelę o więcej niż 50 punktów.
	if (scrollView.contentOffset.y < -50.0f)
		addItemsTrigger = YES;
}

- (UITableViewCell *)tableView:(UITableView *)aTableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
	// Użycie istniejącej komórki lub utworzenie nowej.
	UITableViewCellStyle style =  UITableViewCellStyleDefault;
	UITableViewCell *cell = [aTableView dequeueReusableCellWithIdentifier:@"BaseCell"];
	if (!cell) 
        cell = [[UITableViewCell alloc] initWithStyle:style reuseIdentifier:@"BaseCell"] ;
	
	cell.textLabel.text = [NSString stringWithFormat:@"Komórka %d", numberOfItems - indexPath.row];
	return cell;
}

- (void) loadView
{
    [super loadView];
    numberOfItems = 3; // Na początku tabela zawiera kilka komórek.
    
	// Ustawienie obiektu jako delegata widoku przewijanego, który będzie przechwytywał zdarzenia przewijania.
	self.tableView.delegate = self;
	self.tableView.autoresizesSubviews = YES;
	
	// Umieszczenie „Pociągnij, aby wczytać" powyżej tabeli.
	UIView *pullView = [[[NSBundle mainBundle] loadNibNamed:@"HiddenHeaderView" owner:self options:nil] lastObject]; 
	pullView.frame = CGRectOffset(pullView.frame, 0.0f, -pullView.frame.size.height);
	[self.tableView addSubview:pullView];
    
    self.title = @"Demo pociągnij, aby odświeżyć";
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
	UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
    [application setStatusBarHidden:YES];
    [[UINavigationBar appearance] setTintColor:COOKBOOK_PURPLE_COLOR];
    
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	TestBedViewController *tbvc = [[TestBedViewController alloc] init];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:tbvc];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}